#drawsan.py Spectrum drawing from recorded file
# Roland Cordesses,F2DC, March 12, 2007

from pylab import *
from os import getcwd
cur_rep=getcwd()
from os import chdir
chdir(cur_rep)   
nomfic1=raw_input("File name without ext : ")
ext= ".dat"
ext1=".png"
nomfic=nomfic1+ext
nomfic1=nomfic1+ext1
err=0

    
try:
    in_file=open(nomfic,'r')
except:
    print("File not found")
    err=1


    
in_file.seek(0,0)
textdeb=in_file.read(30)

chset=textdeb
chset1=chset.split()

chfrc=chset1[0]
chscan=chset1[1]
chbw=chset1[2]
chvideo=chset1[3]

lengthchfrc=len(chfrc)
unit=chfrc[lengthchfrc-1]

chsetfin="Fc:" +chfrc + "Hz"+ " ScanW:" + chscan+"Hz/div"
chsetfin=chsetfin+" BW:"+chbw+"Hz"+" Vid.Fltr:"+chvideo+"Hz"

for index in range(len(textdeb)):
    if textdeb[index]=='*':
        inddeb=index+3

in_file.seek(inddeb,0)
textdeb=in_file.read(7)
fdeb=float(textdeb)

in_file.seek(-50,2)
textfin=in_file.read(50)

chpro=textfin

for index in range(len(chpro)):
    chtest=ord(chpro[index]) 
    if chtest==13:
        indfin=index+1
        break

in_file.seek(-50+indfin,2)
textfin=in_file.read(7)
ffin=float(textfin)
scan=ffin-fdeb

in_file.seek(inddeb,0)
newtext=in_file.read()
indexfin=newtext.index("*")
finaltext=newtext[:indexfin]

fichtempo=open('tempo','w')
fichtempo.write(finaltext)
fichtempo.close()

in_file.seek(0,0)
in_file.close()

nbmajmarker=scan/10
nbminmarker=nbmajmarker/5
answer1=raw_input("Save picture (y/n) : ")

fichtempo=open('tempo','r')
X=load(fichtempo)


grid(True)
t=X[:,0]
s=X[:,1]   

min=100       
for i in range(len(s)):
    if (s[i]<=min):
        min=s[i]
min_int=int(min/10)
min_int1=10*(min_int)-10

nbmaj_y=10

from matplotlib.ticker import MultipleLocator, FormatStrFormatter
majorLocator=MultipleLocator(nbmajmarker)
minorLocator=MultipleLocator(nbminmarker)
majLocator_y=MultipleLocator(nbmaj_y)
minLocator_y=MultipleLocator(1)
majorFormatter = FormatStrFormatter('%3.2f')


ax=subplot(111)
plot(t,s,linewidth=1)

xlabel(unit+'Hz',fontsize=16)
ylabel('dBm',fontsize=16, rotation=0)
        
xlim(fdeb, ffin) # set x axis limits from read fdeb to ffin
ylim(min_int1,min_int1+80)

ax.xaxis.set_major_formatter(majorFormatter)
ax.xaxis.set_major_locator(majorLocator)
ax.xaxis.set_minor_locator(minorLocator)
ax.yaxis.set_minor_locator(minLocator_y)
ax.yaxis.set_major_locator(majLocator_y)

title(chsetfin)

if (answer1=='y'):
    savefig(nomfic1)

show()
fichtempo.close()

