unit main;

interface

uses
  Registry,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, PegasusControl, ExtCtrls;

type
  TfrmQEXPegasus = class(TForm)
    Pegasus: TmePegasusControl;
    tbAFGain: TTrackBar;
    lblAFGain: TLabel;
    rgMode: TRadioGroup;
    tbFilter: TTrackBar;
    lblFilter: TLabel;
    edFrequency: TEdit;
    lblFrequency: TLabel;
    btnUp: TButton;
    btnDown: TButton;
    rgComPort: TRadioGroup;
    ckbAutoNotch: TCheckBox;
    lblFrequencyDisplay: TLabel;
    pbSMeter: TProgressBar;
    lblS9: TLabel;
    lblp30: TLabel;
    lblp10: TLabel;
    lblp20: TLabel;
    lbl5: TLabel;
    lbl7: TLabel;
    lbl3: TLabel;
    lbl1: TLabel;
    lblp40: TLabel;
    lblp50: TLabel;
    lblp60: TLabel;
    procedure tbAFGainChange(Sender: TObject);
    procedure PegasusAFGain(const Sender: TmePegasusControl);
    procedure rgModeClick(Sender: TObject);
    procedure PegasusRxMode(const Sender: TmePegasusControl);
    procedure tbFilterChange(Sender: TObject);
    procedure PegasusRxFilter(const Sender: TmePegasusControl);
    procedure edFrequencyKeyPress(Sender: TObject; var Key: Char);
    procedure PegasusRxFrequency(const Sender: TmePegasusControl);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure PegasusEncoder(const Sender: TmePegasusControl);
    procedure rgComPortClick(Sender: TObject);
    procedure PegasusComPort(const Sender: TmePegasusControl);
    procedure ckbAutoNotchClick(Sender: TObject);
    procedure PegasusAutoNotch(const Sender: TmePegasusControl);
    procedure PegasusRxMeter(const Sender: TmePegasusControl);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmQEXPegasus: TfrmQEXPegasus;

implementation

{$R *.DFM}


procedure TfrmQEXPegasus.tbAFGainChange(Sender: TObject);
begin
  if not Pegasus.InUpdateNotify then
    Pegasus.AFGain := tbAFGain.Position;
end;

procedure TfrmQEXPegasus.PegasusAFGain(const Sender: TmePegasusControl);
begin
  tbAFGain.Position := Sender.AFGain;
  lblAFGain.Caption := '&AF Gain - ' + IntToStr( Sender.AFGain );
end;

procedure TfrmQEXPegasus.rgModeClick(Sender: TObject);
begin
  if not Pegasus.InUpdateNotify then
    Pegasus.RxMode := rgMode.ItemIndex;
end;

procedure TfrmQEXPegasus.PegasusRxMode(const Sender: TmePegasusControl);
begin
  rgMode.ItemIndex := Sender.RxMode;
end;

procedure TfrmQEXPegasus.tbFilterChange(Sender: TObject);
begin
  if not Pegasus.InUpdateNotify then
    Pegasus.RxFilter := 33 - tbFilter.Position;
end;

procedure TfrmQEXPegasus.PegasusRxFilter(const Sender: TmePegasusControl);
begin
  tbFilter.Position := 33 - Sender.RxFilter;
  lblFilter.Caption := '&Filter - ' + IntToStr( FILTER_WIDTH[Sender.RxFilter] );
end;

procedure TfrmQEXPegasus.edFrequencyKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = #13 then
  try
    Pegasus.RxFrequency := StrToInt( edFrequency.Text );
    Key := #0;
  except
  end;
end;

procedure TfrmQEXPegasus.PegasusRxFrequency(
  const Sender: TmePegasusControl);
begin
  edFrequency.Text := IntToStr( sender.RxFrequency );
  lblFrequencyDisplay.Caption := format( '%.2d.%.3d.%.2d',
    [sender.RxFrequency div 1000000,
    ( sender.RxFrequency mod 1000000 ) div 1000,
    (sender.RxFrequency mod 1000) div 10 ] );
end;

procedure TfrmQEXPegasus.btnUpClick(Sender: TObject);
begin
  Pegasus.RxFrequency := Pegasus.RxFrequency + 10;
end;

procedure TfrmQEXPegasus.btnDownClick(Sender: TObject);
begin
  Pegasus.RxFrequency := Pegasus.RxFrequency - 10;
end;

procedure TfrmQEXPegasus.PegasusEncoder(const Sender: TmePegasusControl);
begin
  Pegasus.RxFrequency := Pegasus.RxFrequency + 10 * Pegasus.LastEncoder;
end;

procedure TfrmQEXPegasus.rgComPortClick(Sender: TObject);
begin
  if not Pegasus.InUpdateNotify then
    Pegasus.ComPort := rgComPort.ItemIndex;
end;

procedure TfrmQEXPegasus.PegasusComPort(const Sender: TmePegasusControl);
begin
   rgComPort.ItemIndex := Sender.COMPort;
end;

procedure TfrmQEXPegasus.ckbAutoNotchClick(Sender: TObject);
begin
  if not Pegasus.InUpdateNotify then
    Pegasus.AutoNotch := ckbAutoNotch.Checked;
end;

procedure TfrmQEXPegasus.PegasusAutoNotch(const Sender: TmePegasusControl);
begin
  ckbAutoNotch.Checked := Sender.AutoNotch;
end;

procedure TfrmQEXPegasus.PegasusRxMeter(const Sender: TmePegasusControl);
begin
  pbSMeter.Position := Sender.LastSMeter shr 8;
end;

procedure TfrmQEXPegasus.FormCreate(Sender: TObject);
var
  Reg: TRegistry;
  ComPort : byte;
  VFORec : TVFORec;
  Params : TPegasusControlRec;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey( '\Software\Pegasus', false ) then
    begin
      if Reg.ReadBinaryData( 'VFO', VFORec, sizeof( TVFORec )) > 0
        then Pegasus.CurrentVFO := VFORec;
      if Reg.ReadBinaryData( 'PARAMS', Params, sizeof( TPegasusControlRec )) > 0
        then Pegasus.CurrentParams := Params;
      try
        ComPort := Reg.ReadInteger( 'COM_PORT' );
        Pegasus.ComPort := ComPort
      except
      end;
    end;
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

procedure TfrmQEXPegasus.FormDestroy(Sender: TObject);
var
  Reg: TRegistry;
  ComPort : byte;
  VFORec : TVFORec;
  Params : TPegasusControlRec;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey( '\Software\Pegasus', true ) then
    begin
      VFORec := Pegasus.CurrentVFO;
      Params := Pegasus.CurrentParams;
      ComPort := Pegasus.ComPort;
      Reg.WriteBinaryData( 'VFO', VFORec, sizeof( TVFORec ));
      Reg.WriteBinaryData( 'PARAMS', Params, sizeof( TPegasusControlRec ));
      Reg.WriteInteger( 'COM_PORT', ComPort );
    end;
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

end.
