#ifndef _DPY_H
#define _DPY_H

class Display
{
    private:

	Adafruit_FT6206 *ctp;
	Adafruit_ILI9341 *tft;
	uint16_t tft_w, tft_h;
	uint32_t restart_ms;
	uint32_t enc_mult;
	uint32_t enc_f0;
	float prev_lat, prev_lng;
	uint8_t prev_bsnr, prev_wsnr;

    public:

	Display();
	void userFreq(void);
	void drawFrequency(uint32_t cHz);
	void drawPower (void);
	void drawCorrection(int32_t cHz);
	void drawMessage (const char *);
	void drawSat(GPS::SatPos &sp);
	void drawNowLoc(GPS::NowLoc &n);
	void drawSNRs (uint8_t worst_snr, uint8_t best_snr);

};


#endif // _DPY_H
