#ifndef _GPS_H
#define _GPS_H

#include <stdint.h>
#include <SoftwareSerial.h>


class GPS
{

    private:

	/* N_GPS_LINES is set to allow capturing the rapid burst of up to 4 GPGSV
	 * while parsing is still catching up.
	 */

	SoftwareSerial *gps_serial;
	#define MAX_GPS_LINE    83			// max NMEA line length with EOS
	#define	N_GPS_LINES	5			// number of lines to collect
	char gps_lines[N_GPS_LINES][MAX_GPS_LINE];	// lines
	uint8_t capture_i;				// head: line being captured
	uint8_t parsed_i;				// tail: line being parsed
	uint8_t gps_line_len;
	uint8_t best_snr, worst_snr;
	uint8_t parseHex (const char h);

	#define GSA_MIN 	3			// GPGSA field for first sat
	#define	GSA_MAX 	14			// GPGSA field for last sat
	#define	MAX_PRNS	(GSA_MAX-GSA_MIN+1)	// number of sats
	uint8_t prns[MAX_PRNS];				// list of PRNs used in fix calculation

    public:

	typedef struct {
	    uint8_t el;					// elevation, 0-90 degs
	    uint16_t az;				// true azimuth, 0-359 degs E of N
	} SatPos;

	typedef struct {
	    float lat, lng;
	    bool lat_n, lng_e;
	    uint8_t year, month, day;
	    uint8_t hour, minute, second;
	} NowLoc;

	GPS();
	void parse(void);
	void poll(void);
	void reset(void);

};

#endif  // _GPS_H
