#!/usr/bin/python3
#
#
#
#  Program to read to control the reflow oven.
# It reads a file named "profile.txt" which is a
# list of times and desired temperatures; once per second.
# This program reads the file and tries to make the oven
# temperature follow that in the file.  The basic oven control
# program is a PD controller (PID without the integral).
# the 'p' coefficient is unity and the differential 
# coefficient is k_d ... a value stored in a file named:
# 'k_d.txt'.  During the program, the time, desired temperature
# and the actual temperature are saved in a file named temperature.txt.
# the program, at the end, plots this file and saves it with the
# name: 'temperature.png.
#
#  The profile file is, itself, generated from a much shorter profile file
# which just gives the desired temperature at desired times.
#
# this program is meant to just run the test_oven program using the testing
# profile which is just go to 200 degrees and stay there.  Looking at the data
# from this run lets one evaluate the correct value to use for k_d
#
# usage:
#		./test_oven.py
#
# Jim Koehler, Comox, BC, January, 2018
#
###############################################

import max31865
import RPi.GPIO as GPIO
import time, math
import test_GPIO as GP
import os

def oven_on():
    GP.fan_on()
    GP.on_led_on()
    GP.ready_off()
    GP.off_led_off()
    return 1
    
def oven_off():
    GP.on_led_off()
    GP.off_led_on()
    return 0 
    
def init_oven():
	inf = open("profile.txt", 'r')
	lines = inf.readlines()
	inf.close()
	inf = open("k_d.txt", 'r')
	k_d = float(inf.readline())
	inf.close()
	return k_d, lines

##########################################
#
# program starts here
#
##########################################

oven_status = 0
GP.init_gpio()
GP.off_led_on()
GP.ready_off()
GP.fan_off()
GP.on_led_off()
previous_T = 0.0
#k_d = -10.0


max = max31865.max31865(8, 9, 10, 11)
GP.init_gpio()
k_d, lines = init_oven()
print("Profile time: ", len(lines))
print("k_d: ", k_d)
temp = max.readTemp()
print(round(temp, 2))
sequence = []
for line in lines:
	sequence.append(line.split())

while (not GP.start_pressed()):
	print(round(max.readTemp(), 2))
	time.sleep(1)
	
fp = open("temperature.txt", 'w')
fp.write('#'+time.strftime('%a_%d_%b_%Y_%H_%M_%S\r\n\n', time.localtime()))


print("Sequence length ", len(sequence))
for i in range(len(sequence)):
    if GP.start_pressed(): oven_status = oven_on()
    if (GP.stop_pressed() or GP.halt_pressed()): break
    s = sequence[i]
    t = int(s[0])
    desired_T = float(s[1])
    actual_T = max.readTemp()
    d_T = actual_T - previous_T
    previous_T = actual_T
    error_signal = (desired_T - actual_T) + (d_T * k_d)
    print(t, desired_T, round(actual_T, 2), round(d_T,2), round(error_signal, 2))
#    print(t, round(actual_T, 2))
#####################  the following statement does all the work
    if (error_signal > 0.0): oven_status = oven_on()
    else: oven_status = oven_off()
#####################
    str='{0}\t{1}\t{2}\t{3}\n\r'.format(t, round(actual_T, 2), 10 * oven_status, desired_T)   
    fp.write(str)        
    time.sleep(0.9)
    
oven_status = oven_off()   
fp.close()
os.system("gnuplot temp.gp")
os.system("feh temp.png&")

while (not (GP.stop_pressed() or GP.halt_pressed())):
    time.sleep(1)
    t = t + 1
    actual_T = max.readTemp()
    print(t, round(actual_T, 2))
    if ((t % 2) == 0): GP.ready_on()
    else: GP.ready_off()
    
GP.fan_off()
if (GP.halt_pressed()): os.system("sudo halt")
GPIO.cleanup()

          
