#!/usr/bin/python3
"""

 Jim Koehler, Comox, April, 2019
 
 
"""

from breezypythongui import EasyFrame
import math
import os
import numpy as np

def s2b(message):
    '''string to bytes'''
    return bytearray(message, "ascii")
    


class Xtal(EasyFrame):
    """Measures crystal parameters"""

    def __init__(self):
        """Sets up the window and widgets."""
        EasyFrame.__init__(self, title = "Xtal Measure Program (W10)")
        self.setSize(700, 200)
        self.setResizable(False)
        self.setBackground("#c00fffc00")

        # Label and field for the centre frequency pound
        self.addLabel(text = "Nominal F (MHz)",
                      row = 0, column = 0, background = "#d80fffd80")
        self.centreField = self.addFloatField(value = 12.0,
                                               row = 0,
                                               column = 0,
                                               width = 8,
                                               precision = 2)

        # Label and field for the refined centrefrequency
        self.addLabel(text = "Centre F (Hz)",
                      row = 0, column = 7, background = "#d80fffd80")
        self.refined_centreField = self.addIntegerField(value = 0,
                                              row = 0,
                                              column = 7,
                                              width = 10)

        # Label and field for the width
        self.addLabel(text = "Width (Hz)",
                      row = 1, column =7, background = "#d80fffd80")
        self.widthField = self.addIntegerField(value = 600,
                                              row = 1,
                                              column =7,
                                              width = 4)
                                              
                                             
        # Label and field for the NUmber
        self.addLabel(text = "Crystal Ident #:",
                      row = 3, column =0, background = "#d80fffd80")
        self.numberField = self.addIntegerField(value = 0,
                                              row = 3,
                                              column = 0,
                                              width = 8)
                                              
                                             
        # Label and field for the Q
        self.addLabel(text = "Q. Factor    =",
                      row = 3, column =1, background = "#d80fffd80")
        self.QField = self.addIntegerField(value = 0,
                                              row = 3,
                                              column =1,
                                              width = 6)
                                              
                                             
        # Label and field for the df
        self.addLabel(text = "Meas. Freq. (Hz)    =",
                      row = 3, column = 6, background = "#d80fffd80")
        self.measured_fField = self.addIntegerField(value = 0,
                                              row = 3,
                                              column = 6,
                                              width = 10)
                                              
                                             
        # Label and field for the R
        self.addLabel(text = "R (Ohms)    =",
                      row = 3, column =7, background = "#d80fffd80")
        self.RField = self.addFloatField(value = 0.0,
                                              row = 3,
                                              column = 7,
                                              width = 10,
                                              precision = 2)
                                              
        # Label and field for the filename
        self.addLabel(text = "Filename",
                      row = 2, column =0, background = "#d80fffd80")
        self.nameField = self.addTextField(text = "****",
                                              row = 2,
                                              column = 0,
                                              width = 8)
                                              
        # The command buttons
        self.addButton(text = "Setup", row = 1, column = 0,
                       columnspan = 2, command = self.startSetup)

        self.addButton(text = "Measure", row = 2, column = 7,
                       columnspan = 2, command = self.startMeasure)

    # The event handling method for the button
    def startSetup(self):
        c = self.centreField.getNumber()
        base_mess = "W10_y_scan_xtal.py "
        mess = base_mess + str(int(c * 1e6))
        mess += " 20000 401 0 0 0 1\n" # write the strays file this time
        #mess += " %Z_METER_COM%"
        print(mess)
        os.system(mess)
        
        v = np.loadtxt("strays.txt")
        fr = str(int(v[0]))
        self.refined_centreField.setNumber(fr)
        trailer = str(v[1]) + ' ' + str(v[2])
        
        mess =  base_mess + fr + ' 2000 41 ' + trailer + ' 1 0\n' # but, not this time
        os.system(mess)
        
    def startMeasure(self):
        base_mess = "W10_y_scan_xtal.py "
        v = np.loadtxt("strays.txt")
        fr =self.refined_centreField.getNumber()
        trailer = str(v[1]) + ' ' + str(v[2])
        wid = self.widthField.getNumber()
        print(wid)
        print('test1')
        mess =  base_mess + str(fr) + ' ' + str(wid) + ' 41 ' + trailer + ' 0 0\n' # don't write strays file
        #mess =  base_mess + str(fr) + ' ' + str(wid) + ' 41 ' + trailer + ' 1 0\n' # plot don't write strays file
        print(mess)
        print('test2')
        os.system(mess)
        os.system("W10_fit_x.py")

        
# Now get the frequency calibration data and calculate the frequency correction factor 

        v = np.loadtxt("frequency_calibration.txt")
        fcf = v[1] / v[0]            

# now, get measured parameters written by the fit program

        v = np.loadtxt("x_params.txt")
        self.QField.setNumber(int(v[2])) 
        fr = round(v[0] * fcf)                                             
        self.measured_fField.setNumber(fr)
        self.RField.setNumber(v[1])
        filename = self.nameField.getText()
        if (filename == "****"):
            return
        else:
            xtal_number = self.numberField.getNumber()
            self.numberField.setNumber(xtal_number + 1)
            fh = open(filename + ".txt", "ba")
            fh.write(s2b(str(xtal_number) + ',' + str(fr) + ',' + str(v[1]) + ',' + str(v[2]) + '\n'))
            fh.close()

#Instantiate and pop up the window."""
if __name__ == "__main__":
    Xtal().mainloop()
