#!/usr/bin/python3
"""

 Jim Koehler, Comox, April, 2019
 
 
"""

from breezypythongui import EasyFrame
import math
import os

class MeasureL(EasyFrame):
    """Computes and displays the square root of an input number."""
    
    def __init__(self):
        """Sets up the window and widgets."""
        EasyFrame.__init__(self, title = "Measure Inductance")
        self.setSize(500, 200)
        self.setResizable(False)
        self.setBackground("#c00fffc00")

        # Label and field for the centre frequency
        self.addLabel(text = "Centre\nfreq. (MHz)",
                      row = 0, column = 0, background = "#d80fffd80")
        self.centreField = self.addFloatField(value = 10.0,
                                               row = 0,
                                               column = 0,
                                               width = 8,
                                               precision = 2)

        # Label and field for the frequency width
        self.addLabel(text = "Width (MHz)",
                      row = 1, column = 0, background = "#d80fffd80")
        self.widthField = self.addFloatField(value = 1.0,
                                              row = 1,
                                              column = 0,
                                              width = 8,
                                              precision = 2)

        # Label and field for the value of C
        self.addLabel(text = "C_series (pF)",
                      row = 2, column = 0, background = "#d80fffd80")
        self.capacityField = self.addFloatField(value = 10.0,
                                              row = 2,
                                              column = 0,
                                              width = 4)
                                              
        self.addLabel(text = "              ", row = 0, column = 1, background = "#c00fffc00")
        self.addLabel(text = "              ", row = 1, column = 1, background = "#c00fffc00")
        self.addLabel(text = "              ", row = 2, column = 1, background = "#c00fffc00")
        
                                              
        # Label and field for the centre frequency
        self.addLabel(text = "Res. F. (MHz)",
                      row = 0, column = 2, background = "#d80fffd80")
        self.resonantFField = self.addFloatField(value = 0.0,
                                               row = 0,
                                               column = 2,
                                               width = 8,
                                               precision = 2)

        # Label and field for the inductance
        self.addLabel(text = "L (uH)",
                      row = 1, column = 2, background = "#d80fffd80")
        self.inductanceField = self.addFloatField(value = 0.0,
                                              row = 1,
                                              column = 2,
                                              width = 8,
                                              precision = 2)

        # Label and field for the value of Q
        self.addLabel(text = "Q",
                      row = 2, column = 2, background = "#d80fffd80")
        self.qField = self.addIntegerField(value = 0.0,
                                              row = 2,
                                              column = 2,
                                              width = 4)
                                              
                                              
                                              

        # The command buttons
        self.addButton(text = "Plot", row = 4, column = 0, command = self.startPlot)
        self.addButton(text = "Go", row = 4, column = 2, command = self.doMeasure)


    def startPlot(self):
        c = self.centreField.getNumber()
        w = self.widthField.getNumber()
        mess = "./y_scan_l.py "
        mess += str(c) + " "
        mess += str(w)
        os.system(mess)
		
    def doMeasure(self):
        os.system("./fit_l.py")
        fh = open("l_params.txt", "rb")
        tmp = bytes.decode(fh.readline())       
        fh.close()
        
        v = str.split(tmp)
        f_0 = float(v[1])   # fitted resonant frequency in MHz
        G  = float(v[2])    # peak conductance in Siemens
#        print(v)
        
        cap = 1.0e-12 * self.capacityField.getNumber()
        omega = 6.28319e6 * f_0
        el = 1.0 / (cap * omega * omega)    # inductance in Farads
        x_L = omega * el
        q = x_L * G
#        print(el * 1.0e6, f_0, q)
        self.resonantFField.setNumber(round(100.0 * f_0) / 100.0) 
        self.inductanceField.setNumber(round(1.0e8 * el) / 100.0) 
        self.qField.setNumber(round(q)) 
          

#Instantiate and pop up the window."""
if __name__ == "__main__":
    MeasureL().mainloop()
