#
# program to plot a scan of admittance vs frequency
# as printed by the zmeter 's' command
#
# Jim Koehler, Comox, December 2017
#
#
# amended April, 2019 to set limits to the xrange as passed arguments
# and to automatically switch from linear to logarithmic if the
# ratio of high to low frequency is greater than or equal to ten
#
set terminal push
set terminal png
unset logscale y
set output "scan.png"
if ((ARG2 / ARG1) >= 10) {set logscale x}
else  {unset logscale x}
set grid mxtics mytics xtics ytics
#set grid
#unset xrange
set xrange [(ARG1/1000000.0):(ARG2/1000000.0)]
set title "Admittance vs Frequency"
set ylabel "Siemens"
set xlabel "Frequency in MHz"
plot "admittance.txt" u ($1/1000000):2 w points t "G" lt rgb "black", "" u ($1/1000000):3 w points t "B" lt rgb "red"
set terminal pop

